/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.StringFunctions;

public final class IntValue {
    public long _val;
    public boolean _unsigned = false;

    private IntValue(long value) {
        this._val = value;
    }

    public IntValue(long value, boolean unsigned) {
        this._val = value;
        this._unsigned = unsigned;
    }

    public IntValue(String lexeme, ErrorReporter ER) {
        char first = lexeme.charAt(0);
        if (first >= '1' && first <= '9') {
            try {
                this._val = Long.parseLong(this.handleTrailingU(this.stripTrailingL(lexeme)));
            }
            catch (NumberFormatException e) {
                ER.error("Comp.Util.NumericTranslation", lexeme);
            }
        } else if (first == '0') {
            if (lexeme.length() > 1) {
                char second = lexeme.charAt(1);
                if (second == 'x' || second == 'X') {
                    String hexLit = this.handleTrailingU(this.stripTrailingL(lexeme.substring(2)));
                    this._val = StringFunctions.translateHexLiteral(hexLit, false);
                } else {
                    this._val = StringFunctions.translateOctalLiteral(this.handleTrailingU(this.stripTrailingL(lexeme)), false);
                }
            } else {
                this._val = 0L;
            }
        } else if (first == 'L') {
            this._val = StringFunctions.translateWideCharacterLiteral(lexeme.substring(1), true);
        } else {
            if (first != '\'') {
                System.err.println("IDL preprocessor: fatal error: unable to convert lexeme to value in constant parser");
            }
            this._val = StringFunctions.translateCharacterLiteral(lexeme, false);
        }
    }

    public void add(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        long orig = this._val;
        this._val += rhs._val;
        if (!this._unsigned && (orig > (long)0 && rhs._val > (long)0 && this._val <= (long)0 || orig < (long)0 && rhs._val < (long)0 && this._val >= (long)0)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void and(IntValue rhs) {
        this._unsigned = false;
        this._val = this._val != (long)0 && rhs._val != (long)0 ? 1 : 0;
    }

    public void bitNot() {
        this._val ^= 0L - 1L;
    }

    public void bitand(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        this._val &= rhs._val;
    }

    public void bitor(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        this._val |= rhs._val;
    }

    public void bitxor(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        this._val ^= rhs._val;
    }

    public void condition(IntValue if_val, IntValue else_val) {
        this._unsigned = if_val._unsigned || else_val._unsigned;
        this._val = this._val != (long)0 ? if_val._val : else_val._val;
    }

    public void div(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        long orig = this._val;
        if (rhs._val == 0L) {
            throw new ArithmeticException("Comp.Arith.divisionByZero");
        }
        this._val /= rhs._val;
    }

    public void eq(IntValue rhs) {
        this._unsigned = false;
        this._val = this._val == rhs._val ? 1 : 0;
    }

    public void ge(IntValue rhs) {
        if (!this._unsigned && !rhs._unsigned) {
            this._val = this._val >= rhs._val ? 1 : 0;
        } else if (this._val >= (long)0 && rhs._val >= (long)0) {
            this._val = this._val >= rhs._val ? 1 : 0;
        } else if (this._val < (long)0 && rhs._val < (long)0) {
            this._val = this._val >= rhs._val ? 0 : 1;
        } else if (this._val >= (long)0 && rhs._val < (long)0) {
            this._val = 0L;
        } else if (this._val < (long)0 && rhs._val >= (long)0) {
            this._val = 1L;
        }
        this._unsigned = false;
    }

    public void gt(IntValue rhs) {
        if (!this._unsigned && !rhs._unsigned) {
            this._val = this._val > rhs._val ? 1 : 0;
        } else if (this._val >= (long)0 && rhs._val >= (long)0) {
            this._val = this._val > rhs._val ? 1 : 0;
        } else if (this._val < (long)0 && rhs._val < (long)0) {
            this._val = this._val > rhs._val ? 0 : 1;
        } else if (this._val >= (long)0 && rhs._val < (long)0) {
            this._val = 0L;
        } else if (this._val < (long)0 && rhs._val >= (long)0) {
            this._val = 1L;
        }
        this._unsigned = false;
    }

    private String handleTrailingU(String lexeme) {
        int len = lexeme.length();
        if (len > 1 && lexeme.charAt(len - 1) == 'u' || lexeme.charAt(len - 1) == 'U') {
            this._unsigned = true;
            return lexeme.substring(0, len - 1);
        }
        return lexeme;
    }

    public void le(IntValue rhs) {
        if (!this._unsigned && !rhs._unsigned) {
            this._val = this._val <= rhs._val ? 1 : 0;
        } else if (this._val >= (long)0 && rhs._val >= (long)0) {
            this._val = this._val <= rhs._val ? 1 : 0;
        } else if (this._val < (long)0 && rhs._val < (long)0) {
            this._val = this._val <= rhs._val ? 0 : 1;
        } else if (this._val >= (long)0 && rhs._val < (long)0) {
            this._val = 1L;
        } else if (this._val < (long)0 && rhs._val >= (long)0) {
            this._val = 0L;
        }
        this._unsigned = false;
    }

    public void logicalNot() {
        this._unsigned = false;
        this._val = this._val == (long)0 ? 1 : 0;
    }

    public void lshift(IntValue rhs) {
        boolean bl = this._unsigned = this._unsigned || rhs._unsigned;
        if (!rhs._unsigned && rhs._val < 0L) {
            this.rshift(new IntValue(-rhs._val));
        } else {
            this._val = rhs._val >= 64L || rhs._unsigned && rhs._val < (long)0 ? 0L : (this._val <<= (int)rhs._val);
        }
    }

    public void lt(IntValue rhs) {
        if (!this._unsigned && !rhs._unsigned) {
            this._val = this._val < rhs._val ? 1 : 0;
        } else if (this._val >= (long)0 && rhs._val >= (long)0) {
            this._val = this._val < rhs._val ? 1 : 0;
        } else if (this._val < (long)0 && rhs._val < (long)0) {
            this._val = this._val < rhs._val ? 0 : 1;
        } else if (this._val >= (long)0 && rhs._val < (long)0) {
            this._val = 1L;
        } else if (this._val < (long)0 && rhs._val >= (long)0) {
            this._val = 0L;
        }
        this._unsigned = false;
    }

    public void mod(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        long orig = this._val;
        if (rhs._val == 0L) {
            throw new ArithmeticException("Comp.Arith.divisionByZero");
        }
        this._val %= rhs._val;
    }

    public void mul(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        long orig = this._val;
        this._val *= rhs._val;
        if (!this._unsigned && (orig != (long)0 && this._val / orig != rhs._val || (this._val & orig & rhs._val) < 0L)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void ne(IntValue rhs) {
        this._unsigned = false;
        this._val = this._val != rhs._val ? 1 : 0;
    }

    public void or(IntValue rhs) {
        this._unsigned = false;
        this._val = this._val != (long)0 || rhs._val != (long)0 ? 1 : 0;
    }

    public void rshift(IntValue rhs) {
        boolean bl = this._unsigned = this._unsigned || rhs._unsigned;
        if (!rhs._unsigned && rhs._val < 0L) {
            this.lshift(new IntValue(-rhs._val));
        } else {
            this._val = this._unsigned ? (rhs._val >= 64L || rhs._unsigned && rhs._val < (long)0 ? 0L : (this._val >>>= (int)rhs._val)) : (rhs._val >= 64L || rhs._unsigned && rhs._val < (long)0 ? (this._val >>= 63) : (this._val >>= (int)rhs._val));
        }
    }

    public void rshift_pad_zero(IntValue rhs) {
        boolean bl = this._unsigned = this._unsigned || rhs._unsigned;
        if (!rhs._unsigned && rhs._val < 0L) {
            this.lshift(new IntValue(-rhs._val));
        } else {
            this._val = rhs._val >= 64L || rhs._unsigned && rhs._val < (long)0 ? 0L : (this._val >>>= (int)rhs._val);
        }
    }

    private String stripTrailingL(String lexeme) {
        int len = lexeme.length();
        if (len > 1 && lexeme.charAt(len - 1) == 'l' || lexeme.charAt(len - 1) == 'L') {
            return lexeme.substring(0, len - 1);
        }
        return lexeme;
    }

    public void sub(IntValue rhs) {
        this._unsigned = this._unsigned || rhs._unsigned;
        long orig = this._val;
        this._val -= rhs._val;
        if (!this._unsigned && (orig > (long)0 && rhs._val > (long)0 && this._val <= (long)0 || orig < (long)0 && rhs._val < (long)0 && this._val >= (long)0)) {
            throw new ArithmeticException("Comp.Arith.signedOverflow");
        }
    }

    public void unaryMinus() {
        this._val = -this._val;
    }
}

